<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-master" page-height="29.5cm" page-width="21cm" margin-top="1cm" margin-bottom="1cm" margin-left="2.5cm" margin-right="2.5cm">
				<fo:region-before margin-right="2.5cm" extent="2.5cm"/>
				<fo:region-body margin-top="3.85cm" margin-bottom="1.35cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-after extent="0.75cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			
			
	<!-- 
	Sacado el for-each que se repite, el de cartas -> mediador, fuera del page-sequence, y así funciona correctamente.
	Se genera un page-sequence por cada mediador, y así se necesita menos memoria.
	Parece que el page-sequence mete el salto de página, por lo que he quitado el break que se utilizaba cuando solo había una page-sequence
	 -->	
	<xsl:for-each select="cartas">
		<xsl:for-each select="mediador">
			<fo:page-sequence master-reference="default-page-master">
				<fo:static-content flow-name="xsl-region-before">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="1cm"/>
						<fo:table-column column-width="14cm"/>
						<fo:table-column column-width="1cm"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell border="0pt solid black">
									<fo:block/>
								</fo:table-cell>
								<fo:table-cell border="0pt solid black">
									<fo:block font-size="11pt" color="#000000" text-align="center">
										<fo:external-graphic src="url(/datos/p06b/file/images/logoActual.jpg)" scaling="non-uniform" alignment-adjust="0%" width="11.5cm" height="1.9cm"/>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell border="0pt solid black">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:table border="0pt solid black" table-layout="fixed">
						<fo:table-column column-width="16cm"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell text-align="center">
									<fo:block line-height="10pt" font-size="7pt" space-before.optimum="1.5pt" space-after.optimum="1.5pt" keep-together="always">
										Donostia-San Sebastián, 1 – 01010 Vitoria-Gasteiz – Tef. 945 01 90 19 – Fax 945 01 90 20
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<!-- xsl:for-each select="cartas"-->
							<!-- xsl:for-each select="mediador"-->
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="9cm"/>
									<fo:table-column column-width="7cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="0pt" padding-before="0pt" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="denominacion">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="direccion">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="codPostal">
														<xsl:apply-templates/>
													</xsl:for-each>&#160;<xsl:for-each select="municipio">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="9cm" padding-start="3pt" padding-end="3pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell font-size="8pt" padding-after="2pt" padding-before="0pt" text-align="left" width="7cm" padding-start="3pt" padding-end="3pt">
												<fo:block>
													<xsl:for-each select="provincia">
														<xsl:apply-templates/>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>

								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="16cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>La Dirección de Política Financiera del Gobierno Vasco, mediante este correo, le comunica que la aplicación informática para la tramitación telemática de la Documentación Estadístico Contable (DEC) de los Mediadores de Seguros del País Vasco correspondiente al ejercicio <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="ejercicio">
																<xsl:apply-templates/>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(DEC-2017), estará operativa durante el periodo comprendido entre el 3 de abril y el 4 de mayo de 2018, ambos inclusive.<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Para remitir la documentación fuera de este plazo deberá solicitarse previamente autorización a la Dirección de Política Financiera del Gobierno Vasco y justificar el retraso.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>El acceso a la aplicación se llevará a cabo desde el portal del Departamento de Hacienda y Economía, a través de <fo:inline color="#0000FF" text-decoration="underline">www.euskadi.eus</fo:inline> con el siguiente trazado: Euskadi.eus; Gobierno Vasco; Departamentos y entidades; Hacienda y Economía; Política Financiera; Mediadores de Seguros; Información para descargar la aplicación para la confección del fichero Declaración Estadístico Contable, o,  directamente a través de <fo:basic-link external-destination="url('http://www.euskadi.eus/informacion/registro-de-mediadores-y-seguros/web01-a2finan/es/')" color="blue" text-decoration="underline">este enlace</fo:basic-link>.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Asimismo, se adjunta las instrucciones para su confección, que podrán consultar en caso de cualquier duda al cumplimentarla.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Respecto a estas indicaciones indicarles que las mismas han sufrido modificaciones respecto a las del año pasado, por ello se reitera que resulta necesario que se tengan en cuenta al objeto de que pueda cumplimentarse adecuadamente la DEC-2017.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Una vez descargada y cumplimentada la documentación estadístico contable, la misma se remitirá al Gobierno Vasco a través de <fo:basic-link external-destination="url('http://www.euskadi.eus/informacion/registro-de-mediadores-y-seguros/web01-a2finan/es/')" color="blue" text-decoration="underline">este enlace</fo:basic-link>.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>En todo caso, si tuviesen dudas de cumplimentación en relación con las modificaciones efectuadas, no duden en realizar las consultas pertinentes.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Con objeto de actuar con la mayor diligencia, cualquier tipo de incidencia o duda que surja durante el plazo de cumplimentación de la DEC-2017, deberá remitirla prioritariamente a la siguiente dirección: <fo:inline color="#0000FF" text-decoration="underline">mediadoresdeseguros@euskadi.eus</fo:inline>. Las dudas se resolverán con la mayor brevedad posible.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Asimismo, las consultas de tipo informático, acceso a la descarga de la aplicación, identificación…, se podrán realizar al CAU (Centro de Atención de Usuarios del Gobierno Vasco) en el teléfono 012, indicando que la consulta es relativa a la aplicación de Mediadores de Seguros (P06b - Mediadores de Seguros).
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Asimismo, tiene a su disposición los siguientes números de teléfonos de contacto en la Dirección de Política Financiera del Gobierno Vasco: 945018910 (Gonzalo Iriondo) y 945018915 (Guillermo Beaskoetxea) para cualquier duda que pudiera surgir relativas a la materia de mediadores de seguros y la cumplimentación DEC, si bien, previamente a realizar una consulta, se recomienda revisar el Manual de Instrucciones DEC.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Les reiteramos la necesidad de extremar la vigilancia en el mantenimiento de los certificados digitales vigentes. Esto es, tanto de los certificados admitidos según lo establecido en el apartado de requisitos previos del Manual de Usuario para acceso a la aplicación, introducción de datos y envío de la DEC, como de los Certificados digitales personales de IZENPE, FNMT o DNI.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="justify" width="16cm" padding-start="3pt" padding-end="6pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Por último señalarles que los Colegios de Mediadores de Euskadi pueden colaborar con Vd. en la elaboración y remisión de la información estadístico contable al Gobierno Vasco.
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
											
										</fo:table-row>
										
									</fo:table-body>
								</fo:table>
								
								
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="16cm"/>
									<fo:table-body>
									
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="1pt">
												<fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													Vitoria-Gasteiz, 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="anyo">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(e)ko 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="mesEU">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each><xsl:text>&#xA;</xsl:text>
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="dia">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>(a)
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="0pt">
												<fo:block>
													Vitoria-Gasteiz, a <xsl:for-each select="/">
													<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="dia">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> de <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="mes">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> de <xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="fechaActual">
																<xsl:for-each select="anyo">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
													<fo:block>
														<fo:leader leader-pattern="space"/>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
													
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="1pt">
												<fo:block>
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="datosDireccion">
																<xsl:for-each select="descDireccionEus">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each> /
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="0pt" padding-after="0pt">
												<fo:block>
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="datosDireccion">
																<xsl:for-each select="descDireccionCas">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
													<fo:block font-size="9pt" color="#000000" text-align="right">
														<fo:external-graphic>
															<xsl:attribute name="src">url(/datos/p06b/file/images/firma<xsl:value-of select="/cartas/datosDireccion/idFicheroUnico"/>.gif)</xsl:attribute>
															<xsl:attribute name="scaling">non-uniform</xsl:attribute>
															<xsl:attribute name="alignment-adjust">0%</xsl:attribute>
															<xsl:attribute name="width">3.25cm</xsl:attribute>
															<xsl:attribute name="height">4cm</xsl:attribute>
														</fo:external-graphic>
													</fo:block>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell font-size="9pt" text-align="right" width="16cm" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>Izpta./Fdo.: 
													<xsl:for-each select="/">
														<xsl:for-each select="cartas">
															<xsl:for-each select="datosDireccion">
																<xsl:for-each select="nombreCompleto">
																	<xsl:apply-templates/>
																</xsl:for-each>
															</xsl:for-each>
														</xsl:for-each>
													</xsl:for-each>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<!-- fo:block break-after="page">
									<xsl:text>&#xA;</xsl:text>
								</fo:block-->
							<!-- /xsl:for-each--><!-- mediador -->
						<!-- /xsl:for-each--><!-- cartas -->
					</fo:block>
				</fo:flow><!-- xsl region body -->
			</fo:page-sequence>
		</xsl:for-each><!-- mediador -->
	</xsl:for-each><!-- cartas -->
			
			
			
			
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
